# -*- coding: utf-8 -*-
#Copyright (C) 2011,2012 Maximilian Maahn, IGMK (mmaahn@meteo.uni-koeln.de)

import matplotlib
matplotlib.use('Agg')
from matplotlib import rc,ticker
import matplotlib.mlab as mlab
import matplotlib.pyplot as plt
import matplotlib.font_manager as font_manager 
import sys
import numpy as np
import glob
import IMProToo
from IMProTooTools import *
import netCDF4
import calendar
import datetime
import os

def unix2timestamp(unix):
  return str(netCDF4.num2date(unix,"seconds since 1970-01-01 00:00:00").strftime("%Y%m%d"))
def timestamp2unix(timestamp):
  return calendar.timegm(datetime.datetime(year = int(timestamp[0:4]), month = int(timestamp[4:6]), day = int(timestamp[6:8]), hour = 0, minute = 0, second = 0).timetuple())

def quicklook(site,ncFileNew,imgFile,imgTitle): 
  """
  Makes Quicklooks of MRR RR, Ze (v1) and W
  Noise Threshold Masks are applied to MRR Ze (v1) and MRR W 
  Bad Data (NT=100) is grey shaded and no NT Masks are applied
  
  @parameter ncPath (str): netcdf file path  
  @parameter ncFile (str): netcdf file name, usually "mrr_site_yyyymmdd.nc" 
  @parameter imgPath (str): image file path  
  @parameter imgFile (str): image file name, extensions determines file format (e.g. png, eps, pdf ...)
  @parameter imgTitle (str): plot title
  @parameter dealiased (boolean): True: use dealiased variables (MRR Ze v1, MRR W v1 with doppler velocity range -6 to 6 m/s). False MRR standard velocity range (MRR Ze, MRR W v0 with doppler velocity range 0 to 12 m/s)
  """
  print "##### " + imgTitle + "######"
  ncDataNew = netCDF4.Dataset(ncFileNew,'r')

  timestampsNew = ncDataNew.variables["time"][:]
  HNew = ncDataNew.variables["height"][:]
  ZeNew = ncDataNew.variables["Ze"][:]
  noiseAveNew = ncDataNew.variables["etaNoiseAve"][:]
  noiseStdNew = ncDataNew.variables["etaNoiseStd"][:]
  spectralWidthNew = ncDataNew.variables["spectralWidth"][:]
  WNew = ncDataNew.variables["W"][:]
  qualityNew = ncDataNew.variables["quality"][:]
  
  ncDataNew.close()
  #
  date = unix2timestamp(timestampsNew[0])
  starttime = timestamp2unix(date)
  endtime = starttime+60*60*24

  HNew[np.isnan(HNew)] = -9999
  ylim = [np.min(HNew[HNew!=-9999]),np.max(HNew)]
  xlim = [starttime,endtime]
  timestampsNew = oneD2twoD(timestampsNew,ZeNew.shape[1],1)

  fig=plt.figure(figsize=(10, 13))
  
  sp1 = fig.add_subplot(511)
  sp1.set_title(imgTitle)
  levels = np.arange(-15,40,0.1)
  plotCF = sp1.contourf(timestampsNew,HNew, ZeNew, levels,cmap=plt.get_cmap("spectral"), extend="both")#
  cbZe=plt.colorbar(plotCF)
  cbZe.set_label('MRR Ze [dBz]')
  sp1.set_ylim(ylim)
  sp1.set_xlim(xlim)

  sp1.axhline(HNew[-1,2])
  sp1.axhline(HNew[-1,29])

  sp2 = fig.add_subplot(512)
  levels = np.arange(-10,18,0.1)
  plotCF = sp2.contourf(timestampsNew,HNew, WNew, levels,cmap=plt.get_cmap("spectral"), extend="both")#
  cbZe=plt.colorbar(plotCF)
  cbZe.set_label('MRR W [m/s]')
  sp2.set_ylim(ylim)
  sp2.set_xlim(xlim)

  sp2.axhline(HNew[-1,2])
  sp2.axhline(HNew[-1,29])
  
  sp3 = fig.add_subplot(513)
  levels = np.arange(0,1.5,0.1)
  plotCF = sp3.contourf(timestampsNew,HNew, spectralWidthNew, levels,cmap=plt.get_cmap("spectral"), extend="both")#
  cbZe=plt.colorbar(plotCF)
  cbZe.set_label('spectralWidth [m/s]')
  sp3.set_ylim(ylim)
  sp3.set_xlim(xlim)

  sp3.axhline(HNew[-1,2])
  sp3.axhline(HNew[-1,29])

  sp4 = fig.add_subplot(514)
  levels = np.arange(1e-10,1e-8,2e-10)
  plotCF = sp4.contourf(timestampsNew,HNew, noiseAveNew, levels,cmap=plt.get_cmap("spectral"), extend="both")#
  cbZe=plt.colorbar(plotCF)
  cbZe.set_label('mean spectral noise [1/m]')
  sp4.set_ylim(ylim)
  sp4.set_xlim(xlim)
  sp4.axhline(HNew[-1,2])
  sp4.axhline(HNew[-1,29])  
  #import pdb;pdb.set_trace()
    

  sp5 = fig.add_subplot(515)
  levels = np.arange(20)
  for i in levels:
    levels[i] = 2**i
  plotCF = sp5.contourf(timestampsNew,HNew, qualityNew, levels,cmap=plt.get_cmap("spectral"), norm = matplotlib.colors.LogNorm())#
  cbZe=plt.colorbar(plotCF)
  cbZe.set_label('quality array')
  sp5.set_ylim(ylim)
  sp5.set_xlim(xlim)
  sp5.axhline(HNew[-1,2])
  sp5.axhline(HNew[-1,29])  
    
    
  #sp1.set_xlim(np.min(timestampsNew),np.max(timestampsNew))
  sp1.set_xticks(np.arange(sp1.get_xlim()[0],sp1.get_xlim()[1],7200))
  sp1.set_xticklabels([])
  
  #sp2.set_xlim(np.min(timestampsNew),np.max(timestampsNew))
  sp2.set_xticks(np.arange(sp1.get_xlim()[0],sp1.get_xlim()[1],7200))
  sp2.set_xticklabels([])

  #sp3.set_xlim(np.min(timestampsNew),np.max(timestampsNew))
  sp3.set_xticks(np.arange(sp1.get_xlim()[0],sp1.get_xlim()[1],7200))
  sp3.set_xticklabels([])

  #sp4.set_xlim(np.min(timestampsNew),np.max(timestampsNew))
  sp4.set_xticks(np.arange(sp1.get_xlim()[0],sp1.get_xlim()[1],7200))
  sp4.set_xticklabels([])

    #pdb.set_trace()
  #sp5.set_xlim(np.min(timestampsNew)-60,np.max(timestampsNew))
  sp5.set_xticks(np.arange(sp5.get_xlim()[0],sp5.get_xlim()[1]+7200,7200))
  niceDates = list()
  for timestamp in np.arange(sp5.get_xlim()[0],sp5.get_xlim()[1]+7200,7200):
    niceDates.append(str(netCDF4.num2date(timestamp,"seconds since 1970-01-01 00:00:00").strftime("%H:%M")))
  sp5.set_xticklabels(niceDates)

    



  plt.subplots_adjust(hspace=0.02,left=0.085,right=0.78)
    
  plt.savefig(imgFile)
  print(imgFile)

  plt.close()
  return 

  

if len(sys.argv) < 4:
  print 'use: batch_makeQuicklooks.py pathIn pathOut site'
  sys.exit()

pathIn = sys.argv[1]
pathOut = sys.argv[2]  
site = sys.argv[3]


try: os.mkdir(pathOut)
except OSError: pass


for ncFileNew in np.sort(glob.glob(pathIn+"/*")):
  date = ncFileNew[-11:-3]
  print date, ncFileNew
  imgFile = pathOut + "/mrr_improtoo_"+IMProToo.__version__+'_'+site+"_"+date+".png"
  imgTitle = site + " " + date + " IMProToo " + IMProToo.__version__
  quicklook(site,ncFileNew,imgFile,imgTitle)

